package w83b.w83bManager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import w83b.Thread.W83bNotificacionThread;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bLotesPreavisosBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bSolicitudPreaviso;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

public class W83bBandejaEntrada implements W83bIBandejaEntrada {

	public List busquedaBandejaEntrada(w83b.w83bBeans.W83bPreavisosBean param) throws Exception{
		List lista= W83bFactoriaDAO.getBandejaEntradaDAO().busquedaBandejaEntrada(param);
		return lista;//NOPMD
	}
	public w83b.w83bBeans.W83bPreavisosBean buscarDetallePreaviso(java.util.HashMap param) throws Exception{
		W83bPreavisosBean preaviso = (W83bPreavisosBean)W83bFactoriaDAO.getBandejaEntradaDAO().buscarDetallePreaviso(param);
		if (W83bUtilidades.sonEspacios(preaviso.getObserv_008())){
			preaviso.setObserv_008("");
		}
		
		//obtenemos los sindicatos promotores del lote
		if(preaviso!=null){
			StringBuffer sindicatos = new StringBuffer("");
			
			if(preaviso.getC_sindi_prom_multi_008()!=null && preaviso.getC_sindi_prom_multi_008().length()>0){
				int tamanyoSindicatos = preaviso.getC_sindi_prom_multi_008().length();
				//Los codigos de sindicatos ocupan 3 digitos por lo que dividimos el texto de sindicatos de 3 en 3
				while (tamanyoSindicatos>0){
					if(sindicatos.length()>0){
						sindicatos.append(", ");
					}
					sindicatos.append(preaviso.getC_sindi_prom_multi_008().substring(tamanyoSindicatos-3, tamanyoSindicatos));
					tamanyoSindicatos= tamanyoSindicatos-3;
				}
				
				//Hacemos la busqueda en base de datos de los sindicatos
				preaviso.setSindicatosPromotores(W83bFactoriaDAO.getSindicatosDAO().obtenerSindicatosPreaviso(sindicatos.toString()));
			}else if(preaviso.getC_sindi_prom_008()!=null && preaviso.getC_sindi_prom_008().length()>0){
				//Hacemos la busqueda en base de datos de los sindicatos
				preaviso.setSindicatosPromotores(W83bFactoriaDAO.getSindicatosDAO().obtenerSindicatosPreaviso(preaviso.getC_sindi_prom_008()));
			}
			
		}
		
		return preaviso;
	}
	
	public List validarDescartarPreaviso(java.util.HashMap param) throws Exception{
		List preavisos = new ArrayList();
		try{
			W83bPreavisosBean preavisonuevo = (W83bPreavisosBean)param.get("w83bPreavisosNuevoBean");
			W83bPreavisosBean preavisoantiguo = (W83bPreavisosBean)param.get("w83bPreavisosAntiguoBean");
			if (Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.validar",preavisonuevo.getIdioma(),null).equals(preavisonuevo.getAccion())){
				//Insertar preaviso e historial de accesos
				String numpreaviso = W83bFactoriaDAO.getBandejaEntradaDAO().anyadirPreavisos(preavisonuevo);
				preavisonuevo.setNum_preaviso(numpreaviso);
				preavisoantiguo.setNum_preaviso(numpreaviso);
				preavisoantiguo.setAnyoPreaviso(preavisonuevo.getAnyoPreaviso());
				//Insertar promotor
				W83bFactoriaDAO.getBandejaEntradaDAO().anyadirPromotores(preavisonuevo);
				//Insertar historial de tramitacin
				W83bFactoriaDAO.getBandejaEntradaDAO().anyadirHistorialTramitacion(preavisonuevo,W83bClsConstantes.FASE_TRAMITACION_PREAVISO,W83bClsConstantes.TRAMITE_RECEPCION_PREAVISO_E_INICIACION_EXPED,preavisonuevo.getFechaRegES());
				//Insertar preaviso original con los datos originales de la tabla 8
				W83bFactoriaDAO.getBandejaEntradaDAO().insertarPreavisoOriginal(preavisoantiguo);
				//Modificar estado en tabla de preavisos pendientes
				W83bFactoriaDAO.getBandejaEntradaDAO().modificarEstadoPreaviso(preavisonuevo, W83bClsConstantes.CONSTANTE_VALIDADA);
				//Insertar nuevo registro con tipo V en tabla de preavisos pendientes
				W83bFactoriaDAO.getBandejaEntradaDAO().insertarPreavisoModificado(preavisonuevo, W83bClsConstantes.CONSTANTE_VALIDADA ,W83bClsConstantes.TIPOPREAVISOVUELTA);
			}else{
				//Modificar estado registo de tabla de preavisos pendientes
				W83bFactoriaDAO.getBandejaEntradaDAO().modificarEstadoPreaviso(preavisonuevo, W83bClsConstantes.CONSTANTE_DESCARTADA);
				//Insertar nuevo registro con tipo V en tabla de preavisos pendientes
				W83bFactoriaDAO.getBandejaEntradaDAO().insertarPreavisoModificado(preavisonuevo, W83bClsConstantes.CONSTANTE_DESCARTADA, W83bClsConstantes.TIPOPREAVISOVUELTA);
			}
			//Una vez modificado el preaviso, comprobar si hay que notificar el lote si se han validado o descartado todos los preavisos del mismo
			String numpreavisos=W83bFactoriaDAO.getBandejaEntradaDAO().verSiLoteCompleto(preavisonuevo);
			
			if (Integer.parseInt(numpreavisos)==Integer.parseInt(preavisonuevo.getN_preavisos_007())){
				//Hay que generar el fichero de vuelta y notificar, por lo que buscamos todos los preavisos. Si no, lista vaca
				preavisos = W83bFactoriaDAO.getBandejaEntradaDAO().buscarPreavisosVueltaTratados(preavisonuevo);
			}
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "validarDescartarPreaviso",null);
			throw e;
		}
		
		return preavisos;
	}
	
	public w83b.w83bBeans.W83bDocBean generarficherovuelta(java.util.List param, W83bUsuarioXLNetsBean usuario, String idioma) throws Exception{
		List resultado = param;
		W83bDocBean docBean= new W83bDocBean();//NOPMD
		W83bPreavisosBean preavisocabecera=(W83bPreavisosBean)resultado.get(0);
		try{
			
			StringBuffer nombreFichero=new StringBuffer(W83bClsConstantes.CUARENTA);
			nombreFichero.append("preavisoEJ").append("_");
			nombreFichero.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getCodTerritorio(), "0", 2, true));
			nombreFichero.append(preavisocabecera.getNombre_fichero_ida_007().substring(16));
			
			File fichero = new File(nombreFichero.toString());
	        fichero.createNewFile();
	        
	        //El BufferedWriter sera para abrir el fichero
	        //BufferedWriter bw;
	        //bw = new BufferedWriter(new FileWriter(fichero.getAbsolutePath()));
	        
	        StringBuffer total = new StringBuffer();
	        StringBuffer linea = new StringBuffer();
	        
	        //Registro de cabecera
	        linea.append("1"); //Tipo de registro
	        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getCodTerritorio(), "0", 2, true)); //Cdigo de territorio del lote
	        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getC_sindi_007(), " ", 3, true)); //Cdigo de sindicato
	        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getCorrel_007(), " ", 3, true)); //Nmero correlativo
	        linea.append(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preavisocabecera.getF_creacion_007()), " ", 8, true)); //Fecha creacin
	        linea.append("\r\n");
	        total.append(linea.toString());
	        
	        int numtrabtot=0;
	        int cenafectot=0;
	        
	        //Registro de detalle
	        for (int i=0; i<resultado.size(); i++){
	        	W83bPreavisosBean preaviso=(W83bPreavisosBean)resultado.get(i);
	        	linea = new StringBuffer();//NOPMD
	        	linea.append("2"); //Tipo de registro
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCifpreaviso(), " ", 9, false)); //CIF/NIF
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getIdentfiscal(), " ", 1, true)); //Identificacin fiscal
	        	String razonsocial="";
	        	if (preaviso.getRazonSocialPreaviso()!=null){
	        		if (preaviso.getRazonSocialPreaviso().length()>50){
	            		razonsocial=preaviso.getRazonSocialPreaviso().substring(0,50);
	            	}
	            	else{
	            		razonsocial=preaviso.getRazonSocialPreaviso().substring(0,preaviso.getRazonSocialPreaviso().length());
	            	}
	        	}
	        	
	        	linea.append(W83bUtilidades.rellenarCaracter(razonsocial, " ", 50, false)); //Razn social
	        	String domicilio="";
	        	if (preaviso.getDomic_008()!=null){
	        		if (preaviso.getDomic_008().length()>50){
	            		domicilio=preaviso.getDomic_008().substring(0,50);
	            	}
	            	else{
	            		domicilio=preaviso.getDomic_008().substring(0,preaviso.getDomic_008().length());
	            	}
	        	}
	        	
	        	linea.append(W83bUtilidades.rellenarCaracter(domicilio, " ", 50, false)); //Domicilio
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getProvincia(), "0", 2, true)); //Territorio del centro de trabajo
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCodMunicipio(), "0", 3, true)); //Municipio del centro de trabajo
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCodpos_008(), "0", 5, true)); //Cdigo postal del centro de trabajo
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getTelefono_008(), " ", 15, false)); //Telfono
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getFax_008(), " ", 15, false)); //Fax
	        	String email="";
	        	if (preaviso.getEmail_008()!=null){
	        		if (preaviso.getEmail_008().length()>50){
	            		email=preaviso.getEmail_008().substring(0,50);
	            	}
	            	else{
	            		email=preaviso.getEmail_008().substring(0,preaviso.getEmail_008().length());
	            	}
	        	}
	        	
	        	linea.append(W83bUtilidades.rellenarCaracter(email, " ", 50, false)); //Email
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCnae_008(), " ", 4, false)); //CNAE
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getTerritsegsocial(), "0", 2, true)); //Territorio seguridad social
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getNumsegsocial(), " ", 7, false)); //Nmero seguridad social
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getDigcontsegsocial(), " ", 2, false)); //Control seguridad social
	        	linea.append(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preaviso.getFecha_inicio()), " ", 8, true)); //Fecha inicio
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getC_conv_008(), " ", 3, true)); //Cdigo de convenio
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getS_parcial_008(), " ", 1, false)); //Eleccin parcial
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getGlobal_008(), " ", 1, false)); //Preaviso global        	
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getN_cenafec_008(), " ", 6, true)); //Nm centros afectados
	        	cenafectot+=Integer.parseInt(preaviso.getN_cenafec_008());
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getNumtrab(), " ", 6, true)); //Nm trabajadores
	        	numtrabtot+=Integer.parseInt(preaviso.getNumtrab());
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getAdmonemp_008(), " ", 1, false)); //Administracin/Empresa
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getC_sindi_prom_008(), " ", 3, true)); //Cdigo de promotor
	        	linea.append(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preaviso.getFechaRegES()), " ", 8, true)); //Fecha registro
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getNumRegES(), " ", 15, false)); //Nmero de registro
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCodTerritorio(), "0", 2, true)); //Codificacin de preaviso (Territ)
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getAno_preaviso_008(), " ", 4, false)); //Ao
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getN_preaviso_008(), "0", 6, true)); //Nmero de preaviso
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getIdent_008(), " ", 50, false)); //Identificador
	        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getObserv_008(), " ", 255, false)); //Observaciones
	        	linea.append("\r\n");
	        	total.append(linea.toString());
	        	
	        	//Comprobamos si el promotor es multiple para aadir la linea de promotores mltiples
	        	if(W83bClsConstantes.VARIOS_SINDICATOS_PROMOTORES.equals(preaviso.getC_sindi_prom_008())){
	        		linea = new StringBuffer();//NOPMD
	        		linea.append("4"); //Tipo de registro: linea de promotores mltiples
	        		linea.append(preaviso.getC_sindi_prom_multi_008());
		        	linea.append("\r\n");
		        	total.append(linea.toString());
	        	}
	        	
	        }
	        
	        //Registro de control
	        linea = new StringBuffer();
	        linea.append("3"); //Tipo de registro
	        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getN_preavisos_007(), "0", 3, true)); //Nmero total de preavisos
	        linea.append(W83bUtilidades.rellenarCaracter(String.valueOf(cenafectot), " ", 9, true)); //Nmero total de centros afectados
	        linea.append(W83bUtilidades.rellenarCaracter(String.valueOf(numtrabtot), " ", 9, true)); //Nmero total de trabajadores
	        linea.append("\r\n");
	        total.append(linea.toString());

	        
			byte[] bytes = total.toString().getBytes();
			InputStream input=new ByteArrayInputStream(bytes);//NOPMD
			docBean.setFileData(input);
			docBean.setTamanyo(total.toString().getBytes().length);
			docBean.setNombre(nombreFichero.toString());
			W83bLotesPreavisosBean lotesPreavisosBean = new W83bLotesPreavisosBean();
			W83bSolicitudPreaviso solicitudPreaviso = new W83bSolicitudPreaviso();
			solicitudPreaviso.setCorrelativoFichero(preavisocabecera.getCorrel_007());
			solicitudPreaviso.setFechaCreacion(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preavisocabecera.getF_creacion_007()), " ", 8, true));
			solicitudPreaviso.setListaPreavisos(new ArrayList(resultado));
			solicitudPreaviso.setSindicato(preavisocabecera.getC_sindi_007());
			solicitudPreaviso.setTerritorioCabecera(preavisocabecera.getCodTerritorio());
			solicitudPreaviso.setTotalCentrosAfectados(String.valueOf(cenafectot));
			solicitudPreaviso.setTotalNumeroTrabajadores(String.valueOf(numtrabtot));
			lotesPreavisosBean.setSolicitudPreaviso(solicitudPreaviso);
			lotesPreavisosBean.setCodLote(preavisocabecera.getLote());
			lotesPreavisosBean.setDocumentoImportadoOriginal(total.toString());
		    lotesPreavisosBean.setUsuarioBean(usuario);
		    lotesPreavisosBean.setIdioma(idioma);
		    lotesPreavisosBean.setNombreFichero(nombreFichero.toString());
			docBean.setLotesPreavisosBean(lotesPreavisosBean);
			
			Runtime garbage = Runtime.getRuntime();
		    System.runFinalization();
		    System.gc();  	   
		    garbage.gc();
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "generarficherovuelta",null);
			throw e;
		}
		return docBean;
		
	}
	
	public java.lang.String insertarFicheroVuelta(w83b.w83bBeans.W83bDocBean param) throws Exception{
		try{
			W83bFactoriaDAO.getBandejaEntradaDAO().insertarFicheroVuelta(param);
			W83bFactoriaDAO.getBandejaEntradaDAO().modificarCampoTratado(param.getLotesPreavisosBean());
			byte[] bytes = new byte[1024*1024*2];//NOPMD
			int leido = 0;
		    ByteArrayOutputStream b = new ByteArrayOutputStream();//NOPMD
		    InputStream i = (InputStream)param.getFileData();
		    while ((leido = i.read(bytes)) != -1)
		        b.write(bytes,0,leido);

		    param.getLotesPreavisosBean().getUsuarioBean().setSessionTokenXLNets(W83bNotificacionThread.getTokenXLNets("w83b"));
			W83bFactoriaDAO.getBandejaEntradaDAO().generarNotificaciones(param.getLotesPreavisosBean());
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "insertarFicheroVuelta",null);
			throw e;
		}
		return "0";
		
	}
	
}